/*------------------------------------------------------------------------------*
 * File Name:	PeakRectControlList.h											*
 * Creation: 	Hong 02/25/08													*
 * Purpose: OriginC Source H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 02/11/10 QA81-15085 PA_INTEG_FAILS_WHEN_SCALE_IN						*
 *------------------------------------------------------------------------------*/
 
#ifndef _PEAK_RECT_CONTROL_LIST_H_
#define _PEAK_RECT_CONTROL_LIST_H_



class PeakRectControlList : public ShapeControlList
{
public:	
	///------ Folger 02/11/10 QA81-15085 PA_INTEG_FAILS_WHEN_SCALE_IN
	PeakRectControlList();
	~PeakRectControlList();
	///------ End PA_INTEG_FAILS_WHEN_SCALE_IN

	/**$
		Parameter:
			vSrcX = [input] source data of X column to do peak finding
			vSrcY = [input] source data of Y column to do peak finding
			bUpdate = [input] whether update setting in trSettings by refinding peaks
	 	return -1 if fail create
			   -2 if fail update
			   0 if success
	*/
    int CreateList(Layer& lay, LPCSTR lpcszNameBase, int nMaxNum, int nNum, TreeNode& trSettings, const vector& vSrcX, const vector& vSrcY, 
    	bool bUpdate = false, bool bSkipRevise = false, int nMainObj = GROT_RECT, BOOL bLine = false, BOOL bTitle = false, BOOL bLabel=false);    
    /**$
    		Update the peak line of the special peak control with its current range define by rectangle object
    	Parameter:
    		nIndex = [input] the index of control in list which need update its peak
    		vxBaseLine = [input] X column data of base line to do subtraction
    		vyBaseLine = [input] Y column data of base line to do subtraction
    	return -1 if object is invalid
			   -2 if fail get the shape control
			   0 if success
	*/
    int UpdatePeak(int nIndex, const vector& vxBaseLine = NULL, const vector& vyBaseLine = NULL);
    
    ///Sandy 2008-9-9 Add local baseline to update peaks 
     /**$
    		Update the peak line of the special peak control with its current range define by rectangle object and the local baseline
    	Parameter:
    		nIndex = [input] the index of control in list which need update its peak
			nLocalBaselineType = [input] the local baseline type; 	0: straight line; 1: bspline;
			vxLocalBase = [output] if valid, output local baseline x data
			vyLocalBase = [output] if valid, output local baseline y data
    	return -1 if object is invalid
			   -2 if fail get the shape control
			   -3 if create local baseline fail
			   0 if success
	*/   
    int UpdatePeak(int nIndex, int nLocalBaselineType, vector& vxLocalBase = NULL, vector& vyLocalBase = NULL);
    /**#
    */
    bool SetSource(const vector& vSrcX, const vector& vSrcY); 

	///------ Folger 02/11/10 QA81-15085 PA_INTEG_FAILS_WHEN_SCALE_IN
private:
	void	SetupLTVarTempChange();
	void	CleanupLTVarTempChange();
	///------ End PA_INTEG_FAILS_WHEN_SCALE_IN
    
private:
	vector	m_vSrcX;
	vector	m_vSrcY;	

	///------ Folger 02/11/10 QA81-15085 PA_INTEG_FAILS_WHEN_SCALE_IN
	LTVarTempChange*		m_pLTVarDEL;
	LTVarTempChange*		m_pLTVarDEU;
	///------ End PA_INTEG_FAILS_WHEN_SCALE_IN
};

#endif //_PEAK_RECT_CONTROL_LIST_H_